//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick                 2.5
import QtQuick.Controls.Styles 1.4

import wesual.Ui           1.0

/*!
\qmltype     UiScrollViewStyle
\inqmlmodule we.captivo.Ui
\since       we.captivo.Ui 1.0
\inherits    QtQuick::Controls::Styles
\ingroup     captivo-ui-controls

\brief A custom scrollview style

The UiScrollViewStyle is used by the UiScrollView and defines the look of
the component used across the application.


*/

ScrollViewStyle {
    id : style

    readonly property int scrollBarSize : 17 // + invisible ScrollViewFrame 1 px
    readonly property int scrollHandleSize : 12 + 3
    // effective handle size is 12 + 3 margin for centering

    scrollToClickedPosition : true

    scrollBarBackground : Rectangle {
        color : UiColors.getColor(UiColors.White);

        Component.onCompleted : {
            if (styleData.horizontal) {
                height = scrollBarSize;
            } else {
                width = scrollBarSize;
            }
        }
    }
    decrementControl : Item {}
    incrementControl : Item {}
    corner : Item {}
    frame : Rectangle {
        color : UiColors.getColor(UiColors.White);
    }

    handle : Item {
        width : scrollHandleSize
        height : scrollHandleSize
        onWidthChanged : {
            if (styleData.horizontal || width === scrollHandleSize)
                return;
            width = scrollHandleSize;
        }
        onHeightChanged : {
            if (!styleData.horizontal || height == scrollHandleSize)
                return;
            height = scrollHandleSize;
        }

        Rectangle {
            border {
                width : 1
                color : UiColors.getColor(UiColors.DisabledLightGrey13);
            }
            color : UiColors.getColor(UiColors.HeaderGrey4);
            anchors.fill : parent
            anchors.leftMargin : !styleData.horizontal ? 3 : 0
            anchors.topMargin : styleData.horizontal ? 3 : 0
        }

        MouseArea {
            anchors.fill : parent
            preventStealing : true
            onClicked : { mouse.accepted = true;}
        }
    }
}
